#ifndef EMULATE_SPLIT_TRANSCEIVER_HPP__
#define EMULATE_SPLIT_TRANSCEIVER_HPP__

#include <memory>

#include "Transceiver.hpp"

// Emulate Split Transceiver
//
//  Helper decorator class that encapsulates  the emulation of split TX
//  operation.
//  Hilfsdekoratorklasse, die die Emulation der Split-TX-Operation kapselt
//
//  Responsibilities  // Verantwortlichkeiten
//
//  Delegates  all  but setting  of  other  (split) frequency  to  the
//  wrapped Transceiver instance. Also routes failure signals from the
//  wrapped Transceiver instance to this instances failure signal.
//  Delegiert alle Einstellungen außer der Einstellung der anderen (geteilten)
//  Frequenz an die umschlossene Transceiver-Instanz. Leitet außerdem
//  Fehlersignale von der umschlossenen Transceiver-Instanz an das Fehlersignal
//  dieser Instanz weiter.

//  Intercepts status  updates from  the wrapped  Transceiver instance
//  and re-signals it with the emulated status.
//  Fängt Statusaktualisierungen der umschlossenen Transceiver-Instanz ab
//  und sendet sie mit dem emulierten Status erneut.
//
//  Generates a status update signal if the other (split) frequency is
//  changed, this is necessary  since the wrapped transceiver instance
//  never receives other frequency changes.
//  Erzeugt ein Statusaktualisierungssignal, wenn die andere (geteilte) Frequenz
//  geändert wird. Dies ist notwendig, da die umschlossene Transceiver-Instanz
//  niemals andere Frequenzänderungen empfängt.
//
class EmulateSplitTransceiver final
  : public Transceiver
{
  Q_OBJECT

public:
  // takes ownership of wrapped Transceiver
  explicit EmulateSplitTransceiver (std::unique_ptr<Transceiver> wrapped,
                                    QObject * parent = nullptr);

  void set (TransceiverState const&,
            unsigned sequence_number) noexcept override;

  // forward everything else to wrapped Transceiver
  void start (unsigned sequence_number, JTDXDateTime* jtdxtime) noexcept override {wrapped_->start (sequence_number,jtdxtime);}
  void stop () noexcept override {wrapped_->stop ();}

private:
  void handle_update (TransceiverState const&, unsigned seqeunce_number);

  std::unique_ptr<Transceiver> wrapped_;
  Frequency rx_frequency_;        // requested Rx frequency
  Frequency tx_frequency_;        // requested Tx frequency
  bool split_; // requested split state
};

#endif
